/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.toolkit.admin.result.VWAdminDetailsDialog;
import filenet.vw.toolkit.admin.result.images.VWImageLoader;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class VWAdminErrorsDialog
extends VWModalDialog {
    private boolean m_bCanceled = true;
    private boolean m_bYes = false;
    private JTextArea m_infoTextArea = null;
    private JLabel m_warningIcon = null;
    private JButton m_okButton = new JButton(VWResource.s_OK);
    private JButton m_detailsButton = new JButton(VWResource.s_detailsDots);
    private Vector m_vErrors = new Vector();
    private Frame m_parent = null;

    public VWAdminErrorsDialog(Frame parent, String dlgTitle, String errorMsg, Vector errsVector) {
        super(parent);
        this.m_parent = parent;
        this.m_vErrors = errsVector;
        this.setupLayout(dlgTitle, errorMsg);
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_infoTextArea.setFont(boldFont);
        }
    }

    private void setupLayout(String dlgTitle, String errorMsg) {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("335,200");
        if (dim == null) {
            dim = new Dimension(330, 180);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(dlgTitle);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        this.m_infoTextArea = new JTextArea(errorMsg);
        this.m_infoTextArea.setLineWrap(true);
        this.m_infoTextArea.setWrapStyleWord(true);
        this.m_infoTextArea.setOpaque(false);
        this.m_infoTextArea.setEditable(false);
        VWAccessibilityHelper.setAccessibility(this.m_infoTextArea, this, VWResource.s_infoTextArea, VWResource.s_infoTextArea);
        this.m_warningIcon = new JLabel(VWImageLoader.createImageIcon("warning.gif"));
        VWAccessibilityHelper.setAccessibility(this.m_warningIcon, this, VWResource.s_warningIcon, VWResource.s_warningIcon);
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BoxLayout(iconPanel, 3));
        iconPanel.add(this.m_warningIcon);
        JPanel detailsButtonPanel = new JPanel();
        detailsButtonPanel.setLayout(new FlowLayout(2));
        detailsButtonPanel.add(this.m_detailsButton);
        this.m_detailsButton.setSelected(true);
        VWAccessibilityHelper.setAccessibility(this.m_detailsButton, this, VWResource.s_details, VWResource.s_details);
        this.m_detailsButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        JPanel littlePanel = new JPanel();
        littlePanel.setLayout(new BorderLayout(10, 10));
        littlePanel.add((Component)this.m_infoTextArea, "Center");
        littlePanel.add((Component)iconPanel, "Before");
        mainPanel.add((Component)littlePanel, "First");
        mainPanel.add((Component)detailsButtonPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_okButton);
        VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
        this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        mainPanel.add((Component)buttonPanel, "Last");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        this.m_okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWAdminErrorsDialog.this.setVisible(false);
            }
        });
        this.m_detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWAdminDetailsDialog dlg = new VWAdminDetailsDialog(VWAdminErrorsDialog.this.m_parent, VWAdminErrorsDialog.this.m_vErrors);
                dlg.setVisible(true);
            }
        });
    }
}

